params [["_veh",objNull,[objNull]],["_unloading",false,[false]]];
if (isNull _veh) exitWith {false};
_helper = _veh getVariable ["vurtual_crane_helper",objNull];
if (isNull _helper) exitWith {false};
if (_unloading) then {
	if (count (ropeAttachedObjects _helper) == 0) exitWith {false};
	_obj = (ropeAttachedObjects _helper select 0);
	_pos = (_veh modelToWorldWorld (_veh selectionPosition "crane_end_pos"));
	_tgts = lineIntersectsObjs [_pos,[_pos select 0, _pos select 1, (_pos select 2)-10],_obj,_helper,true];
	{if (typeOf _x == "Rope") then { _tgts deleteAt _forEachIndex}} forEach _tgts;
	_transport = objNull;
	{if (typeOf _x != "RopeSegment") then { _transport = _x}} forEach _tgts; 
	_loaded = _transport setVehicleCargo _obj;
	if (_loaded) then {{ropeDestroy _x} forEach (ropes _helper)};
	_loaded
} else {
	if (count (ropeAttachedObjects _helper) > 0) then {
		{ropeDestroy _x} forEach (ropes _helper);
		true
	} else {
		_pos = (_veh modelToWorldWorld (_veh selectionPosition "crane_end_pos"));
		_tgts = (lineIntersectsObjs [_pos,[_pos select 0, _pos select 1, (_pos select 2)-10],_helper,objNull,true]);
		if (count _tgts < 1) then {
			hint "No object to load.";
			false
		} else {
			_obj = (_tgts select ((count _tgts) - 1));
			if (ropeAttachEnabled _obj) then {
				_mem = (configFile >> "cfgVehicles" >> (typeOf _obj) >> "slingLoadCargoMemoryPoints") call BIS_fnc_getCfgDataArray;
				{ropeCreate [_helper,[0,0,0],_obj,_x,5]} forEach _mem;
				true
			} else {
				hint "Can't load this object.";
				false
			};
		};
	};
};