params [["_veh",objNull,[objNull]],["_unloading",false,[false]],["_obj",objNull,[objNull]]];
if (isNull _veh) exitWith {false};
if (_unloading) then {
	if (isNull _obj || _obj == _veh) exitWith { hint "No object selected."; false};
	if (!isNull (_veh getVariable ["vurtual_ship_crane_obj",objNull])) exitWith {hint "Crane is already loaded."; false};
	if ((isVehicleCargo _obj) != _veh) exitWith {hint "This isn't in the cargo bay."; false};
	objNull setVehicleCargo _obj;
	_obj attachTo [_veh,[0,0,0],"crane_end_pos"];
	_veh setVariable ["vurtual_ship_crane_obj",_obj,true];
	[_veh,_obj] spawn {
		params ["_veh","_obj"];
		waitUntil {sleep 1; ((!alive _obj) || (!alive _veh) || (attachedTo _obj != _veh))};
		if (attachedTo _obj == _veh) then {
			detach _obj;
		};
	};
	true
} else {
	if (!isNull (_veh getVariable ["vurtual_ship_crane_obj",objNull])) then {
		_pos = (_veh modelToWorldWorld (_veh selectionPosition "crane_end_pos"));
		_obj = _veh getVariable ["vurtual_ship_crane_obj",objNull];
		_tgts = lineIntersectsObjs [_pos,[_pos select 0, _pos select 1, (_pos select 2)-10],objNull,objNull,true];
		if (_veh in _tgts) then {
			detach _obj;
			_loaded = (_veh setVehicleCargo _obj);
			if (_loaded) then {
				_veh setVariable ["vurtual_ship_crane_obj",objNull,true];
				true
			} else {
				_obj attachTo [_veh,[0,0,0],"crane_end_pos"];
				hint "Can't load this object.";
				false
			};
		} else {
			detach _obj;
			_veh setVariable ["vurtual_ship_crane_obj",objNull,true];
			true
		};
	} else {
		_pos = (_veh modelToWorldWorld (_veh selectionPosition "crane_end_pos"));
		_tgts = (lineIntersectsObjs [_pos,[_pos select 0, _pos select 1, (_pos select 2)-10],objNull,objNull,true]);
		if (count _tgts < 1) then {
			hint "No object to load.";
			false
		} else {
			_obj = (_tgts select ((count _tgts) - 1));
			if ((_veh canVehicleCargo _obj) select 0) then {
				_obj attachTo [_veh,[0,0,0],"crane_end_pos"];
				_veh setVariable ["vurtual_ship_crane_obj",_obj,true];
				[_veh,_obj] spawn {
					params ["_veh","_obj"];
					waitUntil {sleep 1; ((!alive _obj) || (!alive _veh) || (attachedTo _obj != _veh))};
					if (attachedTo _obj == _veh) then {
						detach _obj;
					};
				};
				true
			} else {
				if (_obj == _veh) then {
					hint "No object to load.";
				} else {
					hint "Can't load this object.";
				};
				false
			};
		};
	};
};