#define PYLON_SLOT(a,b,c,d) class pylons##a##: pylons1 { \
	priority = a; \
	UIPosition[] = {0.##b##,0.##c##}; \
	attachment = d; \
};


class CfgPatches {
	class vurtual_ship {
		units[] = {
			"vurtual_ship",
			"vurtual_ship_aaf",
			"vurtual_ship_csat",
			"vurtual_ship_big",
			"vurtual_crane",
			"vurtual_destroyer",
			"vurtual_destroyer_aaf",
			"vurtual_destroyer_csat",
			"vurtual_ship_armed",
			"vurtual_ship_armed_aaf",
			"vurtual_ship_armed_csat",
			"vurtual_lhd",
			"vurtual_lcs2"
		};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {"cba_main"};
	};
};
class CfgFunctions {
	
	class vurtual_ship {
		tag = "vurtual_ship";
		class vurtual_shipFunctions {
			file = "\vurtual_ship\fnc";
			class init {};
			class crane {};
			class addAction {};
			class init_player {postInit = 1;};
			class init_big {};
			class init_crane {};
			class crane_cargo {};
			class init_destroyer {};
			class init_lhd {};
			class init_lcs2 {};
			class deck_cargo {};
		};
	};
};
class DefaultVehicleSystemsDisplayManagerLeftSensors {
	class Components {
		class SensorDisplay;
		class MinimapDisplay;
	};
};
class DefaultVehicleSystemsDisplayManagerRightSensors {
	class Components {
		class SensorDisplay;
		class MinimapDisplay;
	};
};
class CBA_Extended_EventHandlers_base;
class SensorTemplateActiveRadar;
class SensorTemplateDataLink;
class SensorTemplatePassiveRadar;
class SensorTemplateAntiRadiation;
class SensorTemplateIR;
class SensorTemplateLaser;
class Optics_Gunner_MBT_01;
class cfgVehicles {
	class Ship;
	class Ship_F: Ship {
		class Components;
		class NewTurret;
	};
	class vurtual_ship_base: Ship_F {
		//autocenter = 0;
		crew = "B_Officer_F";
		scope=1;
		side=1;
		faction = "BLU_F";
		sensorPosition = "pos_radar";
		armor = 800;
		displayName = "Landing Ship";
		Model = "\vurtual_ship\mdl\vurtual_ship.p3d";
		transportSoldier = 5;
		driverAction = "driver_truck_02";
		driverInAction = "driver_truck_02";
		simulation = "shipx";
		waterAngularDampingCoef = 8;
		waterResistanceCoef = 0.0025;
		waterLinearDampingCoefX = 1;
		waterLinearDampingCoefY = 1;
		rudderForceCoef = 20;
		rudderForceCoefAtMaxSpeed = 0.5;
		fuelCapacity = 60000;
		waterLeakiness = 100;
		enableGPS = 1;
		class AcreRacks {
			class Rack_1 {
				displayName = "Radio 1";
				shortName = "R1";
				componentName = "ACRE_VRC103";
				allowedPositions[] = {"crew"};
				disabledPositions[] = {};
				defaultComponents[] = {};
				mountedRadio = "ACRE_PRC117F";
				isRadioRemovable = 0;
				intercom[] = {"intercom_1"};
			};
			class Rack_2 {
				displayName = "Radio 2";
				shortName = "R2";
				componentName = "ACRE_VRC103";
				allowedPositions[] = {"crew"};
				disabledPositions[] = {};
				defaultComponents[] = {};
				mountedRadio = "ACRE_PRC117F";
				isRadioRemovable = 0;
				intercom[] = {"intercom_1"};
			};
		};
		class AcreIntercoms {
			class Intercom_1 {
				displayName = "Intercom";
				shortName = "Intercom";
				allowedPositions[] = {"crew"};
				masterPositions[] = {{"commander"}};
				limitedPositions[] = {};
				numLimitedPositions = 0;
				connectedByDefault = 1;
			};
		};
		tf_RadioType = "tf_rt1523g";
		tf_hasLRradio = 1;
		tf_isolatedAmount = 1;
		tf_range=40000;
		CargoIsCoDriver[] = {1};
		memoryPointsGetInCoDriver = "pos codriver";
		memoryPointsGetInCoDriverDir = "pos codriver dir";
		memoryPointsGetInCargo[] = {"pos codriver"};
		memoryPointsGetInCargoDir[] = {"pos codriver dir"};
		cargoAction[] = {"driver_truck_02"};
		//slingLoadMemoryPoint = "crane_end_pos";
		//maximumLoad = 10000;
		//slingLoadMaxCargoMass = 10000;
		class Hitpoints {
			class HitEngine {
				name = "hit_engine_p";
				radius = 0.1;
				armorComponent = "hit_engine";
				passThrough = 0.5;
				explosionShielding = 0.2;
				armor = 1;
				visual = "-";
			};
			class HitHull {
				name = "hit_hull_p";
				radius = 0.1;
				armorComponent = "hit_hull";
				passThrough = 1;
				explosionShielding = 1;
				armor = 1;
				visual = "-";
				depends = "Total-0.1";
			};
		};
		class MarkerLights {
			class Fore {
				name = "markerlight_fore";
				//direction = "markerlight_fore_dir";
				color[] = {1,1,1};
				ambient[] = {10,10,10};
				activeLight = 0;
				blinking = 0;
				dayLight = 0;
				drawLight = 0;
				drawLightCenterSize = 0.1;
				drawLightSize = 1;
				intensity = 30;
				useFlare = 1;
				flareSize = 1;
				innerAngle = 112;
				outerAngle = 112.5;
				flareMaxDistance = 3100;
				class Attenuation {
					constant = 0;
					hardLimitEnd = 3;
					hardLimitStart = 2.8;
					linear = 1;
					quadratic = 1;
					start = 0;
				};
			};
			class Abaft: Fore {
				name = "markerlight_abaft";
				//direction = "markerlight_abaft_dir";
			};
			class Stern: Fore {
				name = "markerlight_stern";
				//direction = "markerlight_stern_dir";
				innerAngle = 67;
				outerAngle = 67.5;
			};
			class Port: Fore {
				name = "markerlight_port";
				//direction = "markerlight_port_dir";
				innerAngle = 56;
				outerAngle = 56.25;
				color[] = {1,0,0};
				ambient[] = {10,0,0};
			};
			class Starboard: Fore {
				name = "markerlight_starboard";
				innerAngle = 56;
				outerAngle = 56.25;
				//direction = "markerlight_starboard_dir";
				color[] = {0,1,0};
				ambient[] = {0,10,0};
			};
		};
		class Reflectors {
			class LightDeck {
				color[] = {3000, 3000, 3000};
				ambient[] = {10, 10, 10};
				position = "decklight_pos";
				direction = "decklight_dir";
				hitpoint = "decklight";
				selection = "decklight";
				size = 1;
				innerAngle = 10;
				outerAngle = 45;
				coneFadeCoef = 3;
				intensity = 100;
				useFlare = 0;
				dayLight = 0;
				flareSize = 5;
				flareMaxDistance = 1000;
				class Attenuation {
					start = 0;
					constant = 0;
					linear = 0.1;
					quadratic = 0;
					hardLimitStart = 100;
					hardLimitEnd = 300;
				};
			};
		};
				
		class Turrets {
			class MainTurret: NewTurret {
				weapons[] = {"FakeWeapon"};
				animationSourceBody = "MainTurret";
				animationSourceGun = "MainGun";
				animationSourceElevation = "CraneLower";
				selectionFireAnim = "";
				magazines[] = {};
				turretFollowFreeLook = 2;
				gunBeg = "usti hlavne";
				gunEnd = "konec hlavne";
				soundServo[] = {"A3\Sounds_F\vehicles\armor\noises\servo_best",1.41254,1,40};
				gunnerAction = "driver_truck_02";
				gunnerInAction = "driver_truck_02";
				viewGunnerInExternal = 1;
				castGunnerShadow = 0;
				memoryPointGun="";
				memoryPointGunnerOptics="gunnerview";
				showAllTargets = 2;
				maxHorizontalRotSpeed = 0.5;
				maxVerticalRotSpeed = 0.5;
				dontCreateAI = 1;
				turretInfoType="";
				commanding = 0;
				primaryGunner = 1;
				primaryObserver = 0;
				outGunnerMayFire=1;
				gunnerName = "Crane Operator";
				inGunnerMayFire=1;
				minElev = -75;
				maxElev = 0;
				minTurn = -120;
				maxTurn = 120;
				forceHideGunner = 1;
				gunnerForceOptics = 0;
				LODOpticsIn = 0;
				LODTurnedOut = 1200;
				LODTurnedIn = 1200;
				memoryPointsGetInGunner = "pos gunner";
				memoryPointsGetInGunnerDir = "pos gunner dir";
				gunnerOpticsModel = "\A3\weapons_f\reticle\optics_empty";
				startEngine=1;
				stabilizedInAxes=0;
				class ViewOptics {
					initAngleX = 0;
					minAngleX = -30;
					maxAngleX = 30;
					initAngleY = 0;
					minAngleY = -100;
					maxAngleY = 100;
					initFov = 0.7;
					minFov = 0.25;
					maxFov = 1.1;
				};
				class ViewGunner: ViewOptics {};
				class HitPoints {};
			};
			class Searchlight: MainTurret {
				class Reflectors {
					class LightSearch {
						color[] = {3000, 3000, 3000};
						ambient[] = {10, 10, 10};
						position = "searchlight_pos";
						direction = "searchlight_dir";
						hitpoint = "searchlight";
						selection = "searchlight";
						size = 1;
						innerAngle = 5;
						outerAngle = 30;
						coneFadeCoef = 3;
						intensity = 9001;
						useFlare = 1;
						dayLight = 0;
						flareSize = 5;
						flareMaxDistance = 9001;
						class Attenuation {
							start = 0;
							constant = 0;
							linear = 0.1;
							quadratic = 0;
							hardLimitStart = 800;
							hardLimitEnd = 1000;
						};
					};
				};
				dontCreateAI = 0;
				primaryGunner = 0;
				primaryObserver = 1;
				startEngine=0;
				commanding = 1;
				maxTurn = 360;
				minTurn = -360;
				minElev = -45;
				maxElev = 80;
				
				memoryPointsGetInGunner = "pos captain";
				memoryPointsGetInGunnerDir = "pos captain dir";
				gunnerName = "Captain";
				soundServo[] = {"A3\sounds_f\dummysound", db-40, 1.0, 10};
				class ViewOptics: ViewOptics {
					minFov = 0.1;
				};
				memoryPointGun="searchlight_pos";
				memoryPointGunnerOptics="searchlight_pos";
				animationSourceBody = "SearchlightRot";
				animationSourceGun = "SearchlightPitch";
				animationSourceElevation = "";
				proxyIndex = 2;
				stabilizedInAxes = 3;
			};
		};
		radarType = 2;
		weapons[] = {"FakeWeapon"};
		magazines[] = {};
		unitInfoType = "RscUnitInfoNoWeapon";
		extCameraPosition[] = {0,10,-50};
		mapSize = 60;
		showAllTargets = 2;
		radarTargetSize = 0.7;
		class Components: Components {
			class VehicleSystemsDisplayManagerLeft: DefaultVehicleSystemsDisplayManagerLeftSensors {
				class Components: Components {
					class SensorDisplay: SensorDisplay {
						range[] = {16000,8000,4000,2000};
					};
					class MinimapDisplay: MinimapDisplay {
						resource = "RscCustomInfoAirborneMiniMap";
					};
				};
			};
			class VehicleSystemsDisplayManagerRight: DefaultVehicleSystemsDisplayManagerRightSensors {
				class Components: Components {
					class SensorDisplay: SensorDisplay {
						range[] = {16000,8000,4000,2000};
					};
					class MinimapDisplay: MinimapDisplay {
						resource = "RscCustomInfoAirborneMiniMap";
					};
				};
			};
			class SensorsManagerComponent {
				class Components {
					class ActiveRadarSensorComponent: SensorTemplateActiveRadar {
						angleRangeHorizontal = 360;
						angleRangeVertical = 30;
						class AirTarget {
							minRange = 9000;
							maxRange = 9000;
							objectDistanceLimitCoef = -1;
							viewDistanceLimitCoef = -1;
						};
						groundNoiseDistanceCoef = 0.5;
					};
				};
			};
		};
				
		hasGunner = 1;
		class AnimationSources {
			class CraneRotate {
				source = "user";
				initPhase = 0;
				animPeriod = 1;
			};
			class CraneExtend {
				source = "user";
				initPhase = 0;
				animPeriod = 1;
			};
			class CraneLower {
				source = "user";
				initPhase = 0;
				animPeriod = 1;
			};
			class BowRamp {
				source = "user";
				initPhase = 0;
				animPeriod = 2;
			};
			class SternDoor {
				source = "user";
				initPhase = 0;
				animPeriod = 0.5;
			};
			class PortCamera {
				source = "user";
				initPhase = 0;
				animPeriod = 0.5;
			};
			class TurretsHide {
				initPhase = 1;
				source = "user";
				animPeriod = 0.1;
			};
		};
		enginePower = 5000;
		crewCrashProtection = 0.01;
		class RenderTargets {
			class Bow {
				renderTarget = "rendertarget0";
				
				class CameraView1 {
					pointPosition = "PIP0_pos";
					pointDirection = "PIP0_dir";
					renderQuality = 2;
					renderVisionMode = 0;
					fov = 0.7;
				};
			};
			class Port {
				renderTarget = "rendertarget1";
				
				class CameraView1 {
					pointPosition = "PIP1_pos";
					pointDirection = "PIP1_dir";
					renderQuality = 2;
					renderVisionMode = 0;
					fov = 0.7;
				};
			};
			class Stern {
				renderTarget = "rendertarget2";
				
				class CameraView1 {
					pointPosition = "PIP2_pos";
					pointDirection = "PIP2_dir";
					renderQuality = 2;
					renderVisionMode = 0;
					fov = 0.7;
				};
			};
		};
		hiddenSelections[] = {"Camo","Camo1","Camo2","Camo3"}; //Hull, underwater hull, deck, other.
		hiddenSelectionsTextures[] = {
					//"vurtual_ship\tex\lhd_hull_co.paa",
					"#(argb,8,8,3)color(0.522,0.541,0.553,1.0,co)",
					//"vurtual_ship\tex\lhd_hull_dark_co.paa",
					"#(argb,8,8,3)color(0.195,0.205,0.214,1.0,co)",
					"#(argb,8,8,3)color(0.211,0.221,0.231,1.0,co)",
					"#(argb,8,8,3)color(0.522,0.541,0.553,1.0,co)"
				};
		class textureSources {
			class haze_gray {
				displayname = "Haze Gray";
				author = "vurtual";
				textures[] = {
					//"vurtual_ship\tex\lhd_hull_co.paa",
					"#(argb,8,8,3)color(0.522,0.541,0.553,1.0,co)",
					//"vurtual_ship\tex\lhd_hull_dark_co.paa",
					"#(argb,8,8,3)color(0.195,0.205,0.214,1.0,co)",
					"#(argb,8,8,3)color(0.211,0.221,0.231,1.0,co)",
					"#(argb,8,8,3)color(0.522,0.541,0.553,1.0,co)"
				};
				factions[] = {};
			};
			class civil_white {
				displayname = "White/Red";
				author = "vurtual";
				textures[] = {
					"#(argb,8,8,3)color(0.61,0.61,0.57,1.0,co)",
					"#(argb,8,8,3)color(0.37,0.17,0.15,1.0,co)",
					"#(argb,8,8,3)color(0.235,0.254,0.266,1.0,co)",
					"#(argb,8,8,3)color(0.61,0.61,0.57,1.0,co)"
				};
				factions[] = {};
			};
			class civil_black {
				displayname = "Black/Red";
				author = "vurtual";
				textures[] = {
					"#(argb,8,8,3)color(0.195,0.205,0.214,1.0,co)",
					"#(argb,8,8,3)color(0.37,0.17,0.15,1.0,co)",
					"#(argb,8,8,3)color(0.37,0.17,0.15,1.0,co)",
					"#(argb,8,8,3)color(0.61,0.61,0.57,1.0,co)"
				};
				factions[] = {};
			};
			class gray_red {
				displayname = "Gray/Red";
				author = "vurtual";
				textures[] = {
					"#(argb,8,8,3)color(0.522,0.541,0.553,1.0,co)",
					"#(argb,8,8,3)color(0.761,0.376,0.306,1.0,co)",
					"#(argb,8,8,3)color(0.761,0.376,0.306,1.0,co)",
					"#(argb,8,8,3)color(0.522,0.541,0.553,1.0,co)"
				};
				factions[] = {};
			};
			class black_green {
				displayname = "Black/Olive";
				author = "vurtual";
				textures[] = {
					"#(argb,8,8,3)color(0.198,0.198,0.198,1.0,co)",
					"#(argb,8,8,3)color(0.37,0.17,0.15,1.0,co)",
					"#(argb,8,8,3)color(0.329,0.310,0.239,1.0,co)",
					"#(argb,8,8,3)color(0.198,0.198,0.198,1.0,co)"
				};
				factions[] = {};
			};
		};
		class EventHandlers {
			class CBA_Extended_EventHandlers: CBA_Extended_EventHandlers_base {};
			init = "[(_this select 0),''] call vurtual_ship_fnc_init";
		};
		idlerpm=800;
		redrpm=1200;
		#include "sounds.hpp"
		maxSpeed = 55;
		class VehicleTransport {
			class Cargo {
				dimensions[]				= {"VTV_Cargo_Base","VTV_Cargo_Corner"};
				parachuteClass				= "B_Parachute_02_F";
				canBeTransported            = 1;
				parachuteHeightLimit		= 10;
			};
			class Carrier {
				cargoSpacing[]              = {0.2, 0, 0.5};
				cargoBayDimensions[]        = {"VTV_carrier_base", "VTV_carrier_corner"};
				cargoAlignment[]            = {"right","front"};
				maxLoadMass                 = 300000;
				disableHeightLimit			= 0;
				exits[]						= {"VTV_exit_1"};
				unloadingInterval			= 2;
				loadingDistance				= 10;
				loadingAngle				= 60;
				parachuteClassDefault       = "B_Parachute_02_F";
				parachuteHeightLimitDefault = 10000;
			};
		};
	};
	class vurtual_ship: vurtual_ship_base {
		scope = 2;
		class AnimationSources: AnimationSources {
			class BowRamp: BowRamp {
				displayName = "Open Bow Ramp";
			};
		};
		class EventHandlers {
			class CBA_Extended_EventHandlers: CBA_Extended_EventHandlers_base {};
			init = "[(_this select 0),'\A3\Data_F\Flags\Flag_us_co.paa'] call vurtual_ship_fnc_init";
		};
	};
	class vurtual_ship_aaf: vurtual_ship {
		crew = "I_Officer_F";
		side = 2;
		faction = "IND_F";
		class EventHandlers {
			class CBA_Extended_EventHandlers: CBA_Extended_EventHandlers_base {};
			init = "[(_this select 0),'\A3\Data_F\Flags\Flag_aaf_co.paa'] call vurtual_ship_fnc_init";
		};
		hiddenSelections[] = {"Camo","Camo1","Camo2","Camo3"};
		hiddenSelectionsTextures[] = {
			"#(argb,8,8,3)color(0.198,0.198,0.198,1.0,co)",
			"#(argb,8,8,3)color(0.37,0.17,0.15,1.0,co)",
			"#(argb,8,8,3)color(0.329,0.310,0.239,1.0,co)",
			"#(argb,8,8,3)color(0.198,0.198,0.198,1.0,co)"
		};
	};
	class vurtual_ship_csat: vurtual_ship {
		crew = "O_Officer_F";
		side = 0;
		faction = "OPF_F";
		class EventHandlers {
			class CBA_Extended_EventHandlers: CBA_Extended_EventHandlers_base {};
			init = "[(_this select 0),'\A3\Data_F\Flags\Flag_csat_co.paa'] call vurtual_ship_fnc_init";
		};
		hiddenSelections[] = {"Camo","Camo1","Camo2","Camo3"};
		hiddenSelectionsTextures[] = {
			"#(argb,8,8,3)color(0.522,0.541,0.553,1.0,co)",
			"#(argb,8,8,3)color(0.761,0.376,0.306,1.0,co)",
			"#(argb,8,8,3)color(0.761,0.376,0.306,1.0,co)",
			"#(argb,8,8,3)color(0.522,0.541,0.553,1.0,co)"
		};
	};
	class vurtual_ship_big: vurtual_ship_base {
		waterAngularDampingCoef = 10;
		waterResistanceCoef = 0.01;
		waterLinearDampingCoefX = 100;
		waterLinearDampingCoefY = 100;
		radarTargetSize=2;
		scope = 2;
		crew = "C_man_1";
		side=3;
		faction = "CIV_F";
		displayName = "Container Ship";
		Model = "\vurtual_ship\mdl\vurtual_ship_big.p3d";
		class Turrets {
			class Searchlight: NewTurret {
				class Reflectors {
					class LightSearch {
						color[] = {3000, 3000, 3000};
						ambient[] = {10, 10, 10};
						position = "searchlight_pos";
						direction = "searchlight_dir";
						hitpoint = "searchlight";
						selection = "searchlight";
						size = 1;
						innerAngle = 5;
						outerAngle = 30;
						coneFadeCoef = 3;
						intensity = 9001;
						useFlare = 1;
						dayLight = 0;
						flareSize = 5;
						flareMaxDistance = 9001;
						class Attenuation {
							start = 0;
							constant = 0;
							linear = 0.1;
							quadratic = 0;
							hardLimitStart = 800;
							hardLimitEnd = 1000;
						};
					};
				};
				weapons[] = {"FakeWeapon"};
				selectionFireAnim = "";
				magazines[] = {};
				turretFollowFreeLook = 2;
				gunnerAction = "driver_truck_02";
				gunnerInAction = "driver_truck_02";
				viewGunnerInExternal = 1;
				castGunnerShadow = 0;
				showAllTargets = 2;
				maxHorizontalRotSpeed = 2;
				maxVerticalRotSpeed = 2;
				turretInfoType="";
				outGunnerMayFire=1;
				inGunnerMayFire=1;
				forceHideGunner = 1;
				gunnerForceOptics = 0;
				LODOpticsIn = 0;
				LODTurnedOut = 1200;
				LODTurnedIn = 1200;
				gunnerOpticsModel = "\A3\weapons_f\reticle\optics_empty";
				class ViewGunner {
					initAngleX = 0;
					minAngleX = -30;
					maxAngleX = 30;
					initAngleY = 0;
					minAngleY = -100;
					maxAngleY = 100;
					initFov = 0.7;
					minFov = 0.25;
					maxFov = 1.1;
				};
				class HitPoints {};
				primaryGunner = 0;
				primaryObserver = 1;
				startEngine=0;
				commanding = 1;
				maxTurn = 360;
				minTurn = -360;
				minElev = -45;
				maxElev = 80;
				
				memoryPointsGetInGunner = "pos captain";
				memoryPointsGetInGunnerDir = "pos captain dir";
				gunnerName = "Captain";
				soundServo[] = {"A3\sounds_f\dummysound", db-40, 1.0, 10};
				class ViewOptics: ViewGunner {
					minFov = 0.1;
				};
				memoryPointGun="searchlight_pos";
				memoryPointGunnerOptics="searchlight_pos";
				animationSourceBody = "SearchlightRot";
				animationSourceGun = "SearchlightPitch";
				animationSourceElevation = "";
				proxyIndex = 1;
				stabilizedInAxes = 0;
			};
		};
		class EventHandlers {
			class CBA_Extended_EventHandlers: CBA_Extended_EventHandlers_base {};
			init = "_this call vurtual_ship_fnc_init_big";
		};
		enginePower = 150000;
		extCameraPosition[] = {0,10,-150};
		rudderForceCoef = 500;
		class VehicleTransport: VehicleTransport {

			class Carrier: Carrier {

				maxLoadMass                 = 300000000;
				disableHeightLimit			= 1;

			};
		};
	};
	#include "destroyer.hpp"
	#include "lcs2.hpp"
	class House_F;
	class vurtual_ship_hull_big1: House_F {
		destrType = "destructNo";
		displayName = "Ship Hull";
		scope = 1;
		model = "vurtual_ship\mdl\vurtual_hull_big1";
	};
	class vurtual_ship_hull_big2: vurtual_ship_hull_big1 {
		model = "vurtual_ship\mdl\vurtual_hull_big2";
	};
	class vurtual_ship_hull_big3: vurtual_ship_hull_big1 {
		model = "vurtual_ship\mdl\vurtual_hull_big3";
	};
	class vurtual_ship_hull_door: vurtual_ship_hull_big1 {
		model = "vurtual_ship\mdl\vurtual_hull_door";
	};
	class vurtual_ship_hull_hollow: vurtual_ship_hull_big1 {
		model = "vurtual_ship\mdl\vurtual_hull_big_hollow";
	};
	
	class vurtual_destroyer_p0: vurtual_ship_hull_big1 {
		model ="vurtual_ship\mdl\vurtual_destroyer_p0";
	};
	class vurtual_destroyer_p1: vurtual_ship_hull_big1 {
		model ="vurtual_ship\mdl\vurtual_destroyer_p1";
	};
	class vurtual_destroyer_p2: vurtual_ship_hull_big1 {
		model ="vurtual_ship\mdl\vurtual_destroyer_p2";
	};
	class vurtual_destroyer_p3: vurtual_ship_hull_big1 {
		model ="vurtual_ship\mdl\vurtual_destroyer_p3";
	};
	class vurtual_lcs2_p0: vurtual_ship_hull_big1 {
		model ="vurtual_ship\mdl\vurtual_lcs2_p0";
	};
	class vurtual_lcs2_p1: vurtual_ship_hull_big1 {
		model ="vurtual_ship\mdl\vurtual_lcs2_p1";
	};
	class vurtual_lcs2_p2: vurtual_ship_hull_big1 {
		model ="vurtual_ship\mdl\vurtual_lcs2_p2";
	};
	class vurtual_lhd_hull_p0: vurtual_ship_hull_big1 {
		model = "vurtual_ship\mdl\vurtual_lhd_p0";
	};
	class vurtual_lhd_hull_p1: vurtual_ship_hull_big1 {
		model = "vurtual_ship\mdl\vurtual_lhd_p1";
	};
	class vurtual_lhd_hull_p2: vurtual_ship_hull_big1 {
		model = "vurtual_ship\mdl\vurtual_lhd_p2";
	};
	class vurtual_lhd_hull_p3: vurtual_ship_hull_big1 {
		model = "vurtual_ship\mdl\vurtual_lhd_p3";
	};
	class vurtual_lhd_hull_p4: vurtual_ship_hull_big1 {
		model = "vurtual_ship\mdl\vurtual_lhd_p4";
	};
	class vurtual_lhd_hull_p5: vurtual_ship_hull_big1 {
		model = "vurtual_ship\mdl\vurtual_lhd_p5";
	};
	class vurtual_destroyer_p0_a: vurtual_destroyer_p0 {
		model = "\vurtual_ship\mdl\vurtual_destroyer_p0_a.p3d";
	};
	class vurtual_destroyer_p1_a: vurtual_destroyer_p0 {
		model = "\vurtual_ship\mdl\vurtual_destroyer_p1_a.p3d";
	};
	class vurtual_destroyer_p2_a: vurtual_destroyer_p0 {
		model = "\vurtual_ship\mdl\vurtual_destroyer_p2_a.p3d";
	};
	class vurtual_destroyer_p3_a: vurtual_destroyer_p0 {
		model = "\vurtual_ship\mdl\vurtual_destroyer_p3_a.p3d";
	};
	class vurtual_lcs2_p0_a: vurtual_destroyer_p0 {
		model = "\vurtual_ship\mdl\vurtual_lcs2_p0_a.p3d";
	};
	class vurtual_lcs2_p1_a: vurtual_destroyer_p0 {
		model = "\vurtual_ship\mdl\vurtual_lcs2_p1_a.p3d";
	};
	class vurtual_lcs2_p2_a: vurtual_destroyer_p0 {
		model = "\vurtual_ship\mdl\vurtual_lcs2_p2_a.p3d";
	};
	class Tank;
	class Tank_F: Tank{
		class NewTurret;
	};
	class vurtual_crane: Tank_F {
		explosionEffect = "";
		fuelExplosionPower = 0;
		crew = "C_man_1";
		icon = "iconObject_1x1";
		hasDriver=0;
		hasGunner=1;
		scope=2;
		side=3;
		faction = "CIV_F";
		accuracy = 0.001;
		camouflage = 10;
		armor = 200;
		displayName = "Crane";
		Model = "\vurtual_ship\mdl\vurtual_crane.p3d";
		editorSubcategory = "EdSubcat_Turrets";
		unitInfoType = "RscUnitInfoNoWeapon";
		simulation = "tank";
		crewVulnerable=1;
		explosionShielding=0;
		irTarget=0;
		allowTabLock=0;
		cargoAction[] = {"passenger_low01"};
		tf_isolatedAmount = 0;
		numberPhysicalWheels=0;
		hideProxyInCombat=0;
		maximumLoad = 0;
		transportMaxBackpacks=0;
		transportMaxMagazines=12;
		class EventHandlers {
			class CBA_Extended_EventHandlers: CBA_Extended_EventHandlers_base {};
			init = "_this call vurtual_ship_fnc_init_crane";
		};
		transportSoldier = 0;
		ace_cargo_canLoad = 0;
		ace_Cargo_hasCargo = 0;
		ace_dragging_canDrag = 0;
		ace_dragging_canCarry = 0;
		ace_cookoff_probability = 0;
		destrType = "destructDefault";
		fuelCapacity = 0;
		class Turrets {
			class MainTurret: NewTurret {
				weapons[] = {"FakeWeapon"};
				animationSourceBody = "MainTurret";
				animationSourceGun = "MainGun";
				animationSourceElevation = "CraneLower";
				selectionFireAnim = "";
				magazines[] = {};
				turretFollowFreeLook = 2;
				gunBeg = "usti hlavne";
				gunEnd = "konec hlavne";
				soundServo[] = {"A3\Sounds_F\vehicles\armor\noises\servo_best",1.41254,1,40};
				gunnerAction = "driver_truck_02";
				gunnerInAction = "driver_truck_02";
				viewGunnerInExternal = 1;
				castGunnerShadow = 0;
				memoryPointGun="crane_end_pos";
				memoryPointGunnerOptics="gunnerview";
				showAllTargets = 2;
				maxHorizontalRotSpeed = 0.6;
				maxVerticalRotSpeed = 0.3;
				elevationAnimSourceSpeed = 0.3;
				turretInfoType="";
				commanding = 0;
				primaryGunner = 1;
				primaryObserver = 0;
				outGunnerMayFire=1;
				gunnerName = "Crane Operator";
				inGunnerMayFire=1;
				minElev = -75;
				maxElev = 0;
				minTurn = -360;
				maxTurn = 360;
				forceHideGunner = 1;
				gunnerForceOptics = 0;
				LODOpticsIn = 0;
				LODTurnedOut = 1200;
				LODTurnedIn = 1200;
				memoryPointsGetInGunner = "pos gunner";
				memoryPointsGetInGunnerDir = "pos gunner dir";
				gunnerOpticsModel = "\A3\weapons_f\reticle\optics_empty";
				startEngine=0;
				stabilizedInAxes=0;
				class ViewOptics {
					initAngleX = 0;
					minAngleX = -30;
					maxAngleX = 30;
					initAngleY = 0;
					minAngleY = -100;
					maxAngleY = 100;
					initFov = 0.7;
					minFov = 0.25;
					maxFov = 1.1;
				};
				class ViewGunner: ViewOptics {};
				class HitPoints {};
			};
		};
		//pretend static weapon since some mods don't like unconscious people in static weapons
		nameSound = "veh_static_s";
		vehicleClass = "static";
		crewExplosionProtection = 0;
	};
	class vurtual_ship_armed_base: vurtual_ship_base {
		displayName = "Landing Ship (Armed)";
		crewVulnerable = 1;
		forceHideDriver = 1;
		canHideDriver = 1;
		viewDriverInExternal = 1;
		hideProxyInCombat = 1;
		threat[] = {0.3,0.3,0.3};
		class AnimationSources: AnimationSources {
			class TurretsHide: TurretsHide {
				initPhase = 0;
			};
		};
		incomingMissileDetectionSystem = "16";
		class Components {
			class SensorsManagerComponent {
				class Components {
					class ActiveRadarSensorComponent: SensorTemplateActiveRadar {
						angleRangeHorizontal = 360;
						angleRangeVertical = 120;
						aimDown = -45;
						class AirTarget {
							minRange = 9000;
							maxRange = 9000;
							objectDistanceLimitCoef = -1;
							viewDistanceLimitCoef = -1;
						};
						groundNoiseDistanceCoef = 0.5;
					};
				};
			};
		};
		class Turrets: Turrets {
			class MainTurret: MainTurret {};
			class Searchlight: Searchlight {
				visionMode[] = {"Normal", "NVG"};
			};
			class M242TurretFront: NewTurret {
				class Components {
					class VehicleSystemsDisplayManagerLeft: DefaultVehicleSystemsDisplayManagerLeftSensors {
						defaultDisplay = "MinimapDisplay";
						class Components: Components {
							class MinimapDisplay: MinimapDisplay {
								resource = "RscCustomInfoAirborneMiniMap";
							};
							class SensorDisplay: SensorDisplay {
								range[] = {16000,8000,4000,2000};
							};
							class VehicleCommanderDisplay {
								componentType = "TransportFeedDisplayComponent";
								source = "Commander";
							};		
						};
					};
					class VehicleSystemsDisplayManagerRight: VehicleSystemsDisplayManagerLeft {
						x = "(profilenamespace getvariable [""IGUI_GRID_CUSTOMINFORIGHT_X"",	((safezoneX + safezoneW) - (		(10 * 			(			((safezoneW / safezoneH) min 1.2) / 40)) + 0.5 * 			(			((safezoneW / safezoneH) min 1.2) / 40)))])";
						left = 0;
						right = 1;
						defaultDisplay = "SensorDisplay";
					};
				};
				weapons[] = {"vurtual_m242_front"};
				usepip = 2;
				gunbeg = "frontgunbeg";
				gunend = "frontgunend";
				class OpticsIn {
					class Wide {
						opticsDisplayName = "W";
						initAngleX = 0;
						minAngleX = -30;
						maxAngleX = 30;
						initAngleY = 0;
						minAngleY = -100;
						maxAngleY = 100;
						initFov = 0.466;
						minFov = 0.466;
						maxFov = 0.466;
						visionMode[] = {"Normal", "NVG"};
						gunnerOpticsModel = "\A3\Weapons_F\Reticle\Optics_Gunner_MBT_01_w_F.p3d";
					};
					class Medium: Wide {
						opticsDisplayName = "M";
						initFov = 0.093;
						minFov = 0.093;
						maxFov = 0.093;
						gunnerOpticsModel = "\A3\Weapons_F\Reticle\Optics_Gunner_MBT_01_m_F.p3d";
					};
				};
				selectionFireAnim = "";
				magazines[] = {"300Rnd_25mm_shells","300Rnd_25mm_shells","300Rnd_25mm_shells"};
				turretFollowFreeLook = 0;
				gunnerAction = "driver_boat01";
				gunnerInAction = "driver_boat01";
				viewGunnerInExternal = 1;
				castGunnerShadow = 0;
				showAllTargets = 2;
				maxHorizontalRotSpeed = 2;
				maxVerticalRotSpeed = 2;
				canHideGunner = 1;
				turretInfoType = "RscOptics_MBT_01_commander";
				outGunnerMayFire=1;
				inGunnerMayFire=1;
				forceHideGunner = 1;
				gunnerForceOptics = 0;
				LODOpticsIn = 0;
				LODTurnedOut = 1200;
				LODTurnedIn = 1200;
				gunnerOpticsModel = "\A3\weapons_f\reticle\optics_empty";
				class ViewGunner {
					initAngleX = 0;
					minAngleX = -30;
					maxAngleX = 30;
					initAngleY = 0;
					minAngleY = -100;
					maxAngleY = 100;
					initFov = 0.7;
					minFov = 0.25;
					maxFov = 1.1;
				};
				class HitPoints {};
				primaryGunner = 0;
				primaryObserver = 0;
				startEngine=0;
				commanding = 0;
				maxTurn = 150;
				minTurn = -150;
				initTurn = 0;
				minElev = -7;
				maxElev = 65;
				
				memoryPointsGetInGunner = "pos frontgunner";
				memoryPointsGetInGunnerDir = "pos frontgunner dir";
				gunnerName = "M242 Gunner (Front)";
				discreteDistance[] = {300,400,500,600,700,800,900,1000,
				1200,1400,1600,1800,2000,
				2200,2400,2600,2800,3000
				};
				discreteDistanceInitIndex=1;
				soundServo[] = {"A3\Sounds_F\vehicles\armor\noises\servo_best",1.41254,1,40};
				memoryPointGun="frontgunbeg";
				memoryPointGunnerOptics="frontgunnerview";
				animationSourceBody = "FrontTurret";
				animationSourceGun = "FrontGun";
				gun = "FrontGun";
				body = "FrontTurret";
				animationSourceElevation = "";
				proxyIndex = 3;
				stabilizedInAxes = 3;
			};
			class M242TurretLeft: M242TurretFront {
				gunbeg = "leftgunbeg";
				gunend = "leftgunend";
				memoryPointGun="leftgunbeg";
				memoryPointGunnerOptics="leftgunnerview";
				animationSourceBody = "LeftTurret";
				animationSourceGun = "LeftGun";
				memoryPointsGetInGunner = "pos leftgunner";
				memoryPointsGetInGunnerDir = "pos leftgunner dir";
				gunnerName = "M242 Gunner (Left)";
				weapons[] = {"vurtual_m242_left"};
				gun = "LeftGun";
				body = "LeftTurret";
				proxyIndex = 4;
				maxTurn = 190;
				minTurn = -10;
				initTurn = 90;
			};
			class M242TurretRight: M242TurretFront {
				gunbeg = "rightgunbeg";
				gunend = "rightgunend";
				memoryPointGun="rightgunbeg";
				memoryPointGunnerOptics="rightgunnerview";
				animationSourceBody = "RightTurret";
				animationSourceGun = "RightGun";
				memoryPointsGetInGunner = "pos rightgunner";
				memoryPointsGetInGunnerDir = "pos rightgunner dir";
				gunnerName = "M242 Gunner (Right)";
				weapons[] = {"vurtual_m242_right"};
				gun = "RightGun";
				body = "RightTurret";
				proxyIndex = 5;
				maxTurn = -10;
				minTurn = -190;
				initTurn = -90;
			};
		};
	};
	class vurtual_ship_armed: vurtual_ship_armed_base {
		scope = 2;
		class AnimationSources: AnimationSources {
			class BowRamp: BowRamp {
				displayName = "Open Bow Ramp";
			};
		};
		class EventHandlers {
			class CBA_Extended_EventHandlers: CBA_Extended_EventHandlers_base {};
			init = "[(_this select 0),'\A3\Data_F\Flags\Flag_us_co.paa'] call vurtual_ship_fnc_init";
		};
	};
	class vurtual_ship_armed_aaf: vurtual_ship_armed {
		crew = "I_Officer_F";
		side = 2;
		faction = "IND_F";
		class EventHandlers {
			class CBA_Extended_EventHandlers: CBA_Extended_EventHandlers_base {};
			init = "[(_this select 0),'\A3\Data_F\Flags\Flag_aaf_co.paa'] call vurtual_ship_fnc_init";
		};
		hiddenSelections[] = {"Camo","Camo1","Camo2","Camo3"};
		hiddenSelectionsTextures[] = {
			"#(argb,8,8,3)color(0.198,0.198,0.198,1.0,co)",
			"#(argb,8,8,3)color(0.37,0.17,0.15,1.0,co)",
			"#(argb,8,8,3)color(0.329,0.310,0.239,1.0,co)",
			"#(argb,8,8,3)color(0.198,0.198,0.198,1.0,co)"
		};
	};
	class vurtual_ship_armed_csat: vurtual_ship_armed {
		crew = "O_Officer_F";
		side = 0;
		faction = "OPF_F";
		class EventHandlers {
			class CBA_Extended_EventHandlers: CBA_Extended_EventHandlers_base {};
			init = "[(_this select 0),'\A3\Data_F\Flags\Flag_csat_co.paa'] call vurtual_ship_fnc_init";
		};
		hiddenSelections[] = {"Camo","Camo1","Camo2","Camo3"};
		hiddenSelectionsTextures[] = {
			"#(argb,8,8,3)color(0.522,0.541,0.553,1.0,co)",
			"#(argb,8,8,3)color(0.761,0.376,0.306,1.0,co)",
			"#(argb,8,8,3)color(0.761,0.376,0.306,1.0,co)",
			"#(argb,8,8,3)color(0.522,0.541,0.553,1.0,co)"
		};
	};
	#include "cfgTurrets.hpp"
};
#include "cfgWeapons.hpp"

		
