class CfgVehicles
{

	class Helicopter;
	class Helicopter_Base_F: Helicopter {
		class Turrets;
		class Hitpoints;
	};
	class Helicopter_Base_H: Helicopter_Base_F {
		class Turrets: Turrets {
			class MainTurret;
			class CopilotTurret;
		};
		class Components;
		class CargoTurret;
		class AnimationSources;
		class Eventhandlers;
		class Viewoptics;
		class ViewPilot;
		class RotorLibHelicopterProperties;
		class Hitpoints: Hitpoints {
			class HitHull;
			class HitFuel;
			class HitEngine;
			class HitAvionics;
			class HitHRotor;
			class HitVRotor;
		};
		class Reflectors {
			class Right;
		};
	};
	class vurtual_heli_base: Helicopter_Base_H {
		#include "mfd_hud.hpp"
		hiddenSelections[] = {"Camo", "Camo1"};
		hiddenSelectionsTextures[] = {
			"\vurtual_heli\data\uh1y_ext_co.paa",
			"\vurtual_heli\data\uh1y_int_new_co.paa"
		};
		LESH_canBeTowed = 1;
		LESH_towFromFront = 1;
		LESH_AxisOffsetTarget[] = {0,6.8,-1.4};
		LESH_WheelOffset[] = {0,0};
		class textureSources {
			class marines {
				displayname = "USMC";
				author = "vurtual";
				textures[] = {
					"\vurtual_heli\data\uh1y_ext_co.paa",
					"\vurtual_heli\data\uh1y_int_new_co.paa"
				};
				materials[] = {
					"\vurtual_heli\data\uh1y_ext.rvmat",
					"\vurtual_heli\data\uh1y_int.rvmat"
				};
				factions[] = {};
			};
			/*class green {
				displayname = "Green";
				author = "vurtual";
				textures[] = {
					"\vurtual_heli\data\uh1y_ext_green_co.paa",
					"\vurtual_heli\data\uh1y_int_new_co.paa"
				};
				materials[] = {
					"\vurtual_heli\data\uh1y_ext.rvmat",
					"\vurtual_heli\data\uh1y_int.rvmat"
				};
				factions[] = {};
			};*/
		};
		maxFordingDepth = 1;
		driverDoor = "door_right";
		armor = 40;
		class Hitpoints: Hitpoints {
			class HitHull: HitHull {
				armor = 999;
				depends = "Total-0.1";
				radius = 0.01;
				passThrough = 0;
				explosionShielding = 0;
				minimalHit = 0;
			};
			class HitFuel: HitFuel {
				armor = -50;
				radius = 0.25;
				minimalHit = 0.05;
				explosionShielding = 2;
				name = "hit_fuel_p";
				armorComponent = "hit_fuel";
			};
			class HitAvionics: HitAvionics {
				armor = -50;
				radius = 0.35;
				explosionShielding = 1.5;
				visual = "-";
				armorComponent = "hit_instruments";
				name = "hit_instruments_p";
			};
			class HitEngineLeft {
				armor = 1;
				radius = 0.3;
				name = "hit_engine_left_p";
				explosionShielding = 2;
				minimalHit = 0.05;
				visual = "-";
				passThrough = 1;
				armorComponent = "hit_engine_left";
				//material = 51;
			};
			class HitEngineRight: HitEngineLeft {
				armorComponent = "hit_engine_right";
				name = "hit_engine_right_p";
			};
			class HitEngine : HitEngine {
				armor = 999;
				radius = 0.05;
				minimalHit = 1;
				depends = "0.5 * (HitEngineLeft + HitEngineRight)";
			};
			class HitHRotor: HitHRotor {
				minimalHit = 0.05;
				armor = -120;
				radius = 0.45;
				explosionShielding = 2;
				name = "hit_mainrotor_p";
				armorComponent = "hit_mainrotor";
				visual = "mainrotor_static";
			};
			
			class HitVRotor: HitVRotor {
				minimalHit = 0.05;
				armor = -120;
				radius = 0.06;
				explosionShielding = 5;
				name = "hit_tailrotor_p";
				armorComponent = "hit_tailrotor";
				visual = "tailrotor_static";
			};
			class HitBody {
				armor = -1200;
				explosionShielding = 0.2;
				passThrough = 1;
				name = "hit_body_p";
				armorComponent = "hit_body";
				visual = "-";
				radius = 0.3;
			};
			class HitGlass1 {
				name = "hit_glass1_p";
				visual = "glass1";
				armorComponent = "hit_glass1";
				radius = 0.3;
				armor = 1.0;
				explosionShielding = 2.0;
				minimalHit = 0.025;
				passThrough = 0;
			};
			class HitGlass2: HitGlass1 {
				name = "hit_glass2_p";
				visual = "glass2";
				armorComponent = "hit_glass2";
			};
			class HitGlass3: HitGlass1 {
				name = "hit_glass3_p";
				visual = "glass3";
				armorComponent = "hit_glass3";
			};
			class HitGlass4: HitGlass1 {
				name = "hit_glass4_p";
				visual = "glass4";
				armorComponent = "hit_glass4";
			};
			class HitGlass5: HitGlass1 {
				name = "hit_glass5_p";
				visual = "glass5";
				armorComponent = "hit_glass5";
			};
			class HitGlass6: HitGlass1 {
				name = "hit_glass6_p";
				visual = "glass6";
				armorComponent = "hit_glass6";
			};
		};
		altFullForce = 6100;
		altNoForce = 7100;
		mainBladeRadius = 7.44;
		liftForceCoef = 1.1;
		bodyFrictionCoef = 0.85;
		cyclicAsideForceCoef = 0.8;
		cyclicForwardForceCoef = 0.8;
		backRotorForceCoef = 0.8;	
		tailBladeRadius = 1.295;
		backRotorSpeed = 3;
		MainRotorSpeed = 3;
		accuracy = 0.5;
		crewVulnerable = 1;
		displayName = "UH-1Y";
		viewDriverInExternal=1;
		class TransportItems {
			class _xx_FirstAidKit {
				count = 10;
				name = "FirstAidKit";
			};
		};
		model = "\vurtual_heli\vurtual_uh1y.p3d";
		driveOnComponent[] = {"skids"};
		driverAction = "vurtual_heli_pilot_UH1Y";
		driverInAction = "vurtual_heli_pilot_UH1Y";
		GetInAction = "pilot_Heli_Light_02_Enter";
		GetOutAction = "pilot_Heli_Light_02_Exit";
		driverCompartments = "Compartment1";
		cargoCompartments[] = {"Compartment1"};
		getInRadius = 2.5;
		cargoGetInAction[] = {"GetInHelicopterCargo"};
		cargoGetOutAction[] = {"GetOutHelicopterCargo"};
		transportSoldier = 5;
		cargoProxyIndexes[] = {6,7,8,9,10};
		VIVPassengers[] = {4,5,6,7,8};
		cargoAction[] = {"passenger_apc_narrow_generic01"};
		ace_Fastroping_enabled = 1;
		ace_Fastroping_ropeOrigins[] = {"fastrope_left_pos","fastrope_right_pos"};
		ace_Fastroping_onPrepare = "vurtual_heli_fnc_fastrope_prepare";
		ace_fastroping_onCut = "vurtual_heli_fnc_fastrope_cut";
		cargoIsCoDriver[] = {0};
		hideWeaponsCargo = 1;
		maximumLoad = 2000;	
		cargoCanEject = 1;
		driverCanEject = 1;
		hideProxyInCombat = 1;
		forceHideDriver = 1;
		class Exhausts {
			class Exhaust1
			{
				position = "exhaust1";
				direction = "exhaust1_dir";
				effect = "ExhaustsEffectHeliMed";
			};
			class Exhaust2
			{
				position = "exhaust2";
				direction = "exhaust2_dir";
				effect = "ExhaustsEffectHeliMed";
			};
		};
		class EventHandlers {
			init = "[(_this select 0)] call vurtual_heli_fnc_init;";
			class CBA_Extended_EventHandlers: CBA_Extended_EventHandlers_base {};
		};
		lockDetectionSystem = 4+8;
		incomingMissileDetectionSystem = 8+16;
		gunnerHasFlares = 1;
		threat[]={1, 0.05, 0.05};
		class MarkerLights {
			class Stern {
				name = "markerlight_stern";
				color[] = {1,1,1};
				ambient[] = {10,10,10};
				activeLight = 0;
				blinking = 0;
				dayLight = 0;
				drawLight = 0;
				drawLightCenterSize = 0.1;
				drawLightSize = 1;
				intensity = 30;
				useFlare = 1;
				flareSize = 0.2;
				flareMaxDistance = 3100;
				class Attenuation {
					constant = 0;
					hardLimitEnd = 3;
					hardLimitStart = 2.8;
					linear = 1;
					quadratic = 1;
					start = 0;
				};
			};
			class Abaft: Stern {
				name = "markerlight_abaft";
				blinking = 1;
				blinkingPattern[] = {0.5,0.5};
				blinkingStartsOn = 1;
				blinkingPatternGuarantee = 0;
				color[] = {1,0,0};
				ambient[] = {5,0,0};
				drawLight = 1;
				flareSize = 0.25;
			};
			class Port: Stern {
				name = "markerlight_port";
				innerAngle = 56;
				outerAngle = 56.25;
				color[] = {1,0,0};
				ambient[] = {10,0,0};
			};
			class Port2: Port {
				name = "markerlight_port2";
			};
			class Starboard: Stern {
				name = "markerlight_starboard";
				color[] = {0,1,0};
				ambient[] = {0,10,0};
			};
			class Starboard2: Starboard {
				name = "markerlight_starboard2";
			};
		};
		class Reflectors
		{
			class Cabin1
			{
				color[] = {70,5,5};
				ambient[] = {70,5,5};
				position = "cabinlight1";
				direction = "cabinlight2";
				hitpoint = "cabinlight";
				selection = "cabinlight";
				size = 1;
				brightness = 0.1;
				innerAngle = 360;
				outerAngle = 360;
				useFlare = 0;
				class Attenuation
				{
					start = 0;
					constant = 0;
					linear = 1;
					quadratic = 1;

					hardLimitStart = 0.7;
					hardLimitEnd = 0.9;
				};
			};
			class Cabin2: Cabin1 {
				position = "cabinlight2";
				direction = "cabinlight1";
			};
		};
		weapons[] = {"CMFlareLauncher"};
		magazines[] = {"300Rnd_CMFlare_Chaff_Magazine"};
		vurtual_heli_ffvskid[] = {
			{"ffv_leftskid",2,0,"door_left2"},
			{"ffv_rightskid",3,0,"door_right2"},
		};
		vurtual_heli_closedoors = 1;
		receiveRemoteTargets = 1;
		reportRemoteTargets = 1;
		reportOwnPosition = 1;
		showAllTargets = 4;
		class Turrets: Turrets {
			class CopilotTurret: CopilotTurret {
				gunnerCompartments = "Compartment1";
				gunnerDoor = "door_left";
				viewGunnerInExternal = 1;
				LODTurnedOut = 1200;
				class Components: Components {
					#include "vehDisplayManager.hpp"
				};
				primaryGunner = 1;
				primaryObserver = 1;
				canHideGunner = 1;
				forceHideGunner = 1;
				soundAttenuationTurret = "OpenHeliAttenuation";
				//usePip = 1;
				gunnerAction = "vurtual_heli_pilot_UH1Y";
				gunnerInAction = "vurtual_heli_pilot_UH1Y";
				precisegetinout = 1;								
				gunnerGetInAction = "copilot_Heli_Light_02_Enter";	
				gunnerGetOutAction = "copilot_Heli_Light_02_Exit";
				memoryPointsGetInGunner = "pos copilot";
				memoryPointsGetInGunnerDir = "pos copilot dir";
				animationSourceBody="ObsTurret";
				animationSourceGun="ObsGun";
				body="ObsTurret";
				gun="ObsGun";
				gunBeg="gun_end";
				gunEnd="gun_begin";
				memoryPointGun="gun_end";
				weapons[]={"Laserdesignator_mounted"};
				magazines[]={"Laserbatteries"};
				memoryPointGunnerOptics = "optics_commander";
				turretInfoType = "RscOptics_Heli_Attack_01_gunner";
				class Reflectors
				{
					class Middle
					{
						color[] = {7000,7500,10000};
						ambient[] = {70,75,100};
						position = "light";
						direction = "light_dir";
						hitpoint = "light";
						selection = "light";
						size = 1;
						brightness = 1.0;
						class Attenuation
						{
							start = 0;
							constant = 0;
							linear = 0.1;
							quadratic = 0.1;

							hardLimitStart = 500;
							hardLimitEnd = 700;
						};
					};
				};
				class OpticsIn {
					class Wide {
						gunnerOpticsModel = "\A3\Weapons_F_Beta\Reticle\Heli_Attack_01_Optics_Gunner_wide_F";
						initAngleX = 0;
						initAngleY = 0;
						initFov = 0.466;
						maxAngleX = 30;
						maxAngleY = 100;
						maxFov = 0.466;
						minAngleX = -30;
						minAngleY = -100;
						minFov = 0.466;
						opticsDisplayName = "W";
						thermalMode[] = {0,1};
						visionMode[] = {"Normal","Ti"};
					};
					class Medium: Wide {
						gunnerOpticsModel = "\A3\Weapons_F_Beta\Reticle\Heli_Attack_01_Optics_Gunner_medium_F";
						opticsDisplayName = "M";
						initFov = 0.093;
						minFov = 0.093;
						maxFov = 0.093;
					};
					class Narrow: Wide {
						gunnerOpticsModel = "\A3\Weapons_F_Beta\Reticle\Heli_Attack_01_Optics_Gunner_narrow_F";
						opticsDisplayName = "M";
						initFov = 0.029;
						minFov = 0.029;
						maxFov = 0.029;
					};
				};
				canEject = 1;
				minElev = -80; 										
				maxElev = +25;  									
				initElev = 0; 										
				minTurn = -180;  									
				maxTurn = 180;  									
				initTurn = 0; 										
				//gunnerLeftHandAnimName = "lever_copilot";			
				//gunnerRightHandAnimName = "stick_copilot";			
				maxHorizontalRotSpeed = 3;
				maxVerticalRotSpeed = 3;
				class ViewOptics
				{
					initAngleX=0; minAngleX=-30; maxAngleX=+30;
					initAngleY=0; minAngleY=-100; maxAngleY=+100;
					initFov=0.8; minFov=0.0083; maxFov=0.8;
					//visionMode[] = {"Normal", "NVG", "Ti"};
					//thermalMode[] = {0, 1};
				};
				gunnerOpticsModel = "\A3\weapons_f\reticle\optics_empty";
			};
			class CargoTurret_Left: CargoTurret {
				viewGunnerInExternal = 1;
				proxyType = "CPGunner";
				gunnerDoor = "";
				gunnerAction = "passenger_inside_2";
				gunnerInAction = "passenger_inside_2";
				memoryPointsGetInGunner = "pos leftgunner";
				memoryPointsGetInGunnerDir = "pos leftgunner dir";
				gunnerName = "Left Seat FFV";
				gunnerCompartments = "Compartment1";
				ProxyIndex=2;
				isPersonTurret = 1;
				canHideGunner=1;
				forceHideGunner = 1;
				gunnerForceOptics=0;
				maxElev = 20;
				minElev = -45;
				minTurn = -50;
				maxTurn = 35;
				stabilizedInAxes = 0;
				enabledByAnimationSource = "door_left2";
				commanding = -2;
				soundAttenuationTurret = "OpenHeliAttenuation";
				disableSoundAttenuation = 0;
			};
			class CargoTurret_Right: CargoTurret_Left {
				commanding = -3;
				ProxyIndex=3;
				minTurn = -30;
				maxTurn = 65;
				gunnerName = "Right Seat FFV";
				enabledByAnimationSource = "door_right2";
				memoryPointsGetInGunner = "pos rightgunner";
				memoryPointsGetInGunnerDir = "pos rightgunner dir";
			};
			class CargoTurret_Left2: CargoTurret_Left {
				proxyType = "CPCargo";
				commanding = -4;
				enabledByAnimationSource = "ffv_leftskid";
				proxyIndex = 4;
				gunnerName = "Left Skid FFV";
				memoryPointsGetInGunner = "pos leftskid";
				memoryPointsGetInGunnerDir = "pos leftskid dir";
				minElev = -45;
				maxElev = 20;
				minTurn = -40;
				maxTurn = 70;
			};
			class CargoTurret_Right2: CargoTurret_Left2 {
				commanding = -5;
				enabledByAnimationSource = "ffv_rightskid";
				proxyIndex = 5;
				gunnerName = "Right Skid FFV";
				memoryPointsGetInGunner = "pos rightskid";
				memoryPointsGetInGunnerDir = "pos rightskid dir";
				minTurn = -55;
				maxTurn = 55;
			};
		};
		class AnimationSources: AnimationSources {
			class HUDAction {source="user"; animPeriod=2;initPhase = 0;};
			class HUD_hide {
				source = "user";
				animPeriod = 0.1;
				initPhase = 0;
				displayName = "Remove HUD";
			};
			class HUD_Zero_Elevation {
				source = "user";
				AnimPeriod = 0.01;
				initPhase = 1.9;
			};
			class HUD_Zero_Windage: HUD_Zero_Elevation {
				initPhase = 0.575;
			};
			class door_left {
				source = "door";
				animPeriod = 0.5;
				initPhase = 0;
			};
			class door_right: door_left {};
			class doors_pilot_hide {
				source = "user";
				animPeriod = 0.1;
				initPhase = 0;
				displayName = "Hide pilot doors";
			};
			class doors_cargo_hide {
				source = "user";
				animPeriod = 0.1;
				initPhase = 0;
				displayName = "Hide cargo doors";
				onPhaseChanged = "(_this select 0) animateSource ['doors_cargo_hide',(_this select 1),true]; if ((_this select 1)==1) then { (_this select 0) animateDoor ['door_left2',1,true]; (_this select 0) animateDoor ['door_right2',1,true]; };";
			};
			class Door_Left2 {
				source = "door";
				animPeriod = 0.5;
				initPhase = 1;
				displayName = "Open left door";
				onPhaseChanged = "(_this select 0) animateDoor ['door_left2',(_this select 1) max ((_this select 0) animationSourcePhase 'doors_cargo_hide'),true]";
			};
			class Door_Right2 {
				source = "door";
				animPeriod = 0.5;
				initPhase = 1;
				displayName = "Open right door";
				onPhaseChanged = "(_this select 0) animateDoor ['door_right2',(_this select 1) max ((_this select 0) animationSourcePhase 'doors_cargo_hide'),true]";
			};
			class fastrope_prepare {
				source = "user";
				animPeriod = 2;
				initPhase = 0;
			};
			class ffv_leftskid {
				source = "door";
				animPeriod = 0.5;
				initPhase = 0;
			};
			class ffv_rightskid: ffv_leftskid {};
			class bedseat_fold {
				source = "user";
				//lockCargo[] = {4,5,6,7,8};
				lockCargoAnimationPhase = 1;
				initPhase = 0;
				animPeriod = 1;
				displayName = "Enable cargo mode";
				onPhaseChanged = "[(_this select 0),(_this select 1)==1,true] call vurtual_base_fnc_cargobed;";
			};
			class LauncherPylon_hide {
				source = "user";
				animPeriod = 0.1;
				initPhase = 0;
				displayName = "";
			};
			class pintle_mount_hide {
				source = "user";
				animPeriod = 0.1;
				initPhase = 1;
			};
			class HitGlass1 { raw = 1; source = "hit"; hitpoint = "HitGlass1"; };
			class HitGlass2: HitGlass1 { hitpoint = "HitGlass2"; };
			class HitGlass3: HitGlass1 { hitpoint = "HitGlass3"; };
			class HitGlass4: HitGlass1 { hitpoint = "HitGlass4"; };
			class HitGlass5: HitGlass1 { hitpoint = "HitGlass5"; };
			class HitGlass6: HitGlass1 { hitpoint = "HitGlass6"; };
			class HitHRotor: HitGlass1 { hitpoint = "HitHRotor"; };
			class HitVRotor: HitGlass1 { hitpoint = "HitVRotor"; };
		};
		sensorPosition = "optics_commander";
		class Components: Components {
			#include "vehDisplayManager.hpp"
			class SensorsManagerComponent {
				class Components {
					class IRSensorComponent: SensorTemplateIR {
						angleRangeHorizontal = 30;
						angleRangeVertical = 30;
						animDirection = "ObsGun";
					};
					class LaserSensorComponent: SensorTemplateLaser {
						animDirection = "ObsGun";
					};
					class VisualSensorComponent: SensorTemplateVisual {
						angleRangeHorizontal = 30;
						angleRangeVertical = 30;
						animDirection = "ObsGun";
					};
					class PassiveRadarSensorComponent: SensorTemplatePassiveRadar {};
				};
			};
			class TransportPylonsComponent {
				uiPicture = "\A3\Air_F_epb\Heli_Light_03\Data\UI\Heli_Light_03_3DEN_CA.paa";
				class pylons {
					class pylons1 {
						attachment = "vurtual_heli_hydra_7Rnd";
						hardpoints[] = {"DAR","DAGR","B_SHRIEKER","vurtual_heli_pylon"};

						priority = 5;
						UIposition[] = {0.06,0.4};
					};
					class pylons2: pylons1 {
						mirroredMissilePos = 1;
						UIposition[] = {0.59,0.4};
					};
				};
			};
		};
		class UserActions {
			class HUDoff
			{
				displayName="HUD On";
				displayNameDefault="";
				position="zamerny";
				radius=1;
				onlyForPlayer=true;
				condition="(player==driver this)and(this animationSourcePhase 'HUDAction' !=1) and (this animationSourcePhase 'hud_hide' == 0)";
				statement="this animateSource ['HUDAction',1];";
			};
			class HUDon
			{
				displayName="HUD Off";
				displayNameDefault="";
				position="zamerny";
				radius=1;
				onlyForPlayer=true;
				condition="(player==driver this)and(this animationSourcePhase 'HUDAction' !=0) and (this animationSourcePhase 'hud_hide' == 0)";
				statement="this animateSource ['HUDAction',0];";
			};
		};
		//TODO damage
		//TODO RTD
		selectionHRotorStill = "mainrotor_static";
		selectionHRotorMove = "mainrotor_blur";
		selectionVRotorStill = "tailrotor_static";
		selectionVRotorMove = "tailrotor_blur";
		preciseGetInOut=1;
		#include "sounds.hpp"
		class VehicleTransport {
			class Cargo {
				dimensions[]				= {"VTV_Cargo_Base","VTV_Cargo_Corner"};
				parachuteClass				= "B_Parachute_02_F";
				canBeTransported			= 1;
				parachuteHeightLimit		= 10;
			};
			class Carrier {
				cargoBayDimensions[]		= {"VTV_Carrier_Base", "VTV_Carrier_Corner"};
				cargoSpacing[]			  = {0, 0, 0};
				cargoAlignment[]			= {"right","back"};
				maxLoadMass				 = 3020;
				disableHeightLimit			= 0;
				exits[]						= {"VTV_exit_1","VTV_exit_2"};
				unloadingInterval			= 2;
				loadingDistance				= 0;
				loadingAngle				= 0;
				parachuteClassDefault	   = "B_Parachute_02_F";
				parachuteHeightLimitDefault = 20;
			};
		};
		class pilotCamera{
			class OpticsIn {		
				class Wide {
					opticsDisplayName 	= "W";
					initAngleX			= 0;
					minAngleX			= -0;
					maxAngleX			= +0;
					initAngleY			= 0;
					minAngleY			= -0;
					maxAngleY			= +0;
					initFov				= 0.5;
					minFov				= 0.5;
					maxFov				= 0.5;
					visionMode[] 		= {"Normal"};
					thermalMode[] 		= {0,1};
					gunnerOpticsModel = "A3\drones_f\Weapons_F_Gamma\Reticle\UAV_Optics_Gunner_wide_F.p3d";
				};
				showMiniMapInOptics				= false;
				showUAVViewpInOptics			= false;
				showSlingLoadManagerInOptics 	= true;
			};
			minTurn				 = 0;
			maxTurn				 = 0;
			initTurn				= 0;
			minElev				 = 80;
			maxElev				 = 80;
			initElev				= 80;
			maxXRotSpeed			= 0.5;
			maxYRotSpeed			= 0.5;
			pilotOpticsShowCursor   = 1;
			controllable			= false;
		};
		radarType = 4;
		memoryPointDriverOptics = "slingloadcamera";
		slingLoadMemoryPoint 	= "slingLoad0";
	};
	class vurtual_heli_uh1y_base: vurtual_heli_base {
		crewCrashProtection = 0.2;
		maxSpeed = 304;
		fuelCapacity = 1438;
		slingLoadMaxCargoMass 	= 2300;
		armor = 50;
		class Hitpoints: Hitpoints {
			class HitHRotor: HitHRotor {
				armor = -180;
			};
			
			class HitVRotor: HitVRotor {
				armor = -150;
			};
		};
	};
	class vurtual_heli_uh1n_base: vurtual_heli_base {
		LESH_AxisOffsetTarget[] = {0,5.3,-1.4};
		irTargetSize = 0.8;
		crewCrashProtection = 0.25;
		driverAction = "vurtual_heli_pilot_UH1H";
		maxSpeed = 220;
		fuelCapacity = 1131;
		armor = 30;
		slingLoadMaxCargoMass 	= 2000;
		altFullForce = 5200;
		altNoForce = 6200;
		transportSoldier = 5;
		cargoProxyIndexes[] = {7,8,9,11,12};
		VIVPassengers[] = {4,5,6,7,8}; 
		mainBladeRadius = 7.3;
		liftForceCoef = 1;
		bodyFrictionCoef = 0.7;
		cyclicAsideForceCoef = 0.7;
		cyclicForwardForceCoef = 0.7;
		backRotorForceCoef = 0.7;	
		tailBladeRadius = 1.295;
		class textureSources {
			class gray {
				displayname = "Gray";
				author = "vurtual";
				textures[] = {
					"\vurtual_heli\data\uh1n_ext_gray_co.paa",
					"\vurtual_heli\data\uh1y_int_new_co.paa"
				};
				materials[] = {
					"\vurtual_heli\data\uh1n_ext.rvmat",
					"\vurtual_heli\data\uh1y_int.rvmat"
				};
				factions[] = {};
			};
			class gray_usmc {
				displayname = "Gray (USMC)";
				author = "vurtual";
				textures[] = {
					"\vurtual_heli\data\uh1n_ext_gray_usmc_co.paa",
					"\vurtual_heli\data\uh1y_int_new_co.paa"
				};
				materials[] = {
					"\vurtual_heli\data\uh1n_ext.rvmat",
					"\vurtual_heli\data\uh1y_int.rvmat"
				};
				factions[] = {};
			};
			class olive {
				displayname = "Olive";
				author = "vurtual";
				textures[] = {
					"\vurtual_heli\data\uh1n_ext_co.paa",
					"\vurtual_heli\data\uh1y_int_new_co.paa"
				};
				materials[] = {
					"\vurtual_heli\data\uh1n_ext.rvmat",
					"\vurtual_heli\data\uh1y_int.rvmat"
				};
				factions[] = {};
			};
			class black_pmc {
				displayName = "Black";
				author = "vurtual";
				textures[] = {
					"\vurtual_heli\data\uh1n_ext_black_co.paa",
					"\vurtual_heli\data\uh1y_int_new_co.paa"
				};
				materials[] = {
					"\vurtual_heli\data\uh1y_ext.rvmat",
					"\vurtual_heli\data\uh1y_int.rvmat"
				};
				factions[] = {};
			};
			class black_civ {
				displayName = "Black (Civ)";
				author = "vurtual";
				textures[] = {
					"\vurtual_heli\data\uh1n_ext_black_co.paa",
					"\vurtual_heli\data\uh1y_int_new_co.paa"
				};
				materials[] = {
					"\vurtual_heli\data\uh1n_ext_civ.rvmat",
					"\vurtual_heli\data\uh1y_int.rvmat"
				};
				factions[] = {};
			};
			class white_blue {
				displayName = "White/Blue";
				author = "vurtual";
				textures[] = {
					"\vurtual_heli\data\uh1n_ext_white_blue_co.paa",
					"\vurtual_heli\data\uh1y_int_new_co.paa"
				};
				materials[] = {
					"\vurtual_heli\data\uh1n_ext_civ.rvmat",
					"\vurtual_heli\data\uh1y_int.rvmat"
				};
				factions[] = {};
			};
		};
		vurtual_heli_ffvskid[] = {
			{"ffv_leftskid",2,1,"door_left2"},
			{"ffv_rightskid",3,1,"door_right2"},
		};
		class AnimationSources: AnimationSources {
			class antenna_type {
				initPhase = 0;
				animPeriod = 0.1;
				source = "user";
				displayName = "Switch Antenna";
                                onPhaseChanged = "(_this select 0) animateSource ['antenna_type',(_this select 1),true]";
			};
			class doors_cargo_hide: doors_cargo_hide {};
			class door_left2: door_left2 {};
			class door_right2: door_right2 {};
			class HUD_Zero_Elevation: HUD_Zero_Elevation {
				initPhase = 0;
			};
			class HUD_Zero_Windage: HUD_Zero_Windage {
				initPhase = -2.45;
			};
			class bedseat_fold: bedseat_fold {
				//lockCargo[] = {4,5,6,7,8};
			};
			class Stabilizer_hide {
				source = "user";
				initPhase = 1;
				animPeriod = 0.1;
				displayName = "Remove Stabilizer";
			};
			class flares_hide {
				source = "user";
				initPhase = 0;
				animPeriod = 0.1;
			};
			class FLIR_hide {
				source = "user";
				initPhase = 0;
				animPeriod = 0.1;
			};
			class fastrope_hide {
				source = "user";
				initPhase = 0;
				animPeriod = 0.1;
			};
		};
		class Turrets: Turrets {
			class CopilotTurret: CopilotTurret {
				gunnerAction = "vurtual_heli_pilot_UH1H";
			};
			class CargoTurret_Left: CargoTurret_Left {
				minTurn = -5;
			};
			class CargoTurret_Right: CargoTurret_Right {
				maxTurn = -5;
			};
			class CargoTurret_Left2: CargoTurret_Left2 {};
			class CargoTurret_Right2: CargoTurret_Right2 {};
			class CargoTurret_Left3: CargoTurret_Left2 {
				proxyIndex = 6;
				maxTurn = 100;
				minTurn = 45;
				initTurn = 90;
				gunnerName = "FFV Left Front Seat";
				memoryPointsGetInGunner = "pos leftbench";
				memoryPointsGetInGunnerDir = "pos leftbench dir";
				enabledByAnimationSource = "door_left2";
			};
			class CargoTurret_Right3: CargoTurret_Right2 {
				proxyIndex = 10;
				minTurn = -100;
				maxTurn = -45;
				initTurn = -90;
				gunnerName = "FFV Right Front Seat";
				memoryPointsGetInGunner = "pos rightbench";
				memoryPointsGetInGunnerDir = "pos rightbench dir";
				enabledByAnimationSource = "door_right2";
				
			};
		};
		class VehicleTransport: VehicleTransport {
			class Carrier: Carrier {
				maxLoadMass				 = 2000;
				cargoBayDimensions[] = {"VTV_Carrier_Base2","VTV_Carrier_Corner"};
			};
		};
	};
	#include "cfgVehicles_usmc.hpp"
	#include "cfgVehicles_usaf.hpp"
	#include "cfgVehicles_old.hpp"
	#include "cfgVehicles_civ.hpp"
};
